var calSection, calDiv, calSelect, calToggle, calTable, calCurrent, calDisplay, lastCalCurrent, lastCalDisplay;

function calInit() {
  calSection = document.getElementById("calendarSection");
  calDiv = document.getElementById("calDiv");
  calSelect = document.getElementById("calSelect");
  calToggle = document.getElementById("calToggle");
  calTable = document.getElementById("calTable");
  calToggle.src = (calDiv.style.display == "block" ? "/images/close.gif" : "/images/open.gif");
  var date = new Date();
  value = date.getFullYear().toString() + "-" + (date.getMonth() + 1).toString();
  calSelect.value = value;
  changeCal();
  calendarSection.style.display = "block";
//  lastCalCurrent = calCurrent;
//  lastCalDisplay = calDiv.style.display;
//  window.setTimeout(calUpdateSession, 2000);
}

function calPrev() {
  if (calSelect.selectedIndex > 0) --calSelect.selectedIndex;
  changeCal();
}

function calNext() {
  if (calSelect.selectedIndex < calSelect.options.length - 1) ++calSelect.selectedIndex;
  changeCal();
}

function changeCal() {

  var calTemp = calSelect.options[calSelect.selectedIndex].value;
  if (calTemp == calCurrent) return;

  calCurrent = calTemp;
  var divs = document.getElementsByTagName("div");

  for (var i = 0; i < divs.length; ++i) {
    if (divs[i].id.substring(0, 6) == "events") divs[i].style.display = "none";
  }

  var div = document.getElementById("events" + calCurrent);
  if (div) div.style.display = "block";
  fillCal();
}

function fillCal() {

  var m = Number(calCurrent.substring(5, 7));
  var y = Number(calCurrent.substring(0, 4));
  var dt = new Date(y, m, 0);
  var lastDayOfMonth = dt.getDate();
  dt.setFullYear(y, m - 1, 1);
  var firstDayOfWeek = dt.getDay();

  var today = new Date();
  today = new Date(today.getFullYear(), today.getMonth(), today.getDate());

  for (var i = 0; i < 42; ++i) {

    var d = i - firstDayOfWeek + 1;
    var cell = calTable.rows[(i - i % 7) / 7 + 1].cells[i % 7];

    if (d < 1 || d > lastDayOfMonth) {
      cell.innerHTML = "&nbsp;";
      cell.style.backgroundColor = "";
    }
    else {
      dt.setDate(d);
      cell.innerHTML = d.toString();
      cell.style.backgroundColor = (dt.getTime() == today.getTime() ? "#6394F7" : "");
    }
  }
}

function toggleCal() {

  if (calDiv.style.display == "block") {
    calToggle.src = "/images/open.gif";
    calDiv.style.display = "none";
    calOpen = false;
  }
  else {
    calToggle.src = "/images/close.gif";
    calDiv.style.display = "block";
    calOpen = true;
  }
}

function menuOver(cell) {
  cell.style.backgroundColor = "#6394F7";
  getMenuItems(cell.childNodes).style.display = 'block';
}

function menuOut(cell) {
  cell.style.backgroundColor = "";
  getMenuItems(cell.childNodes).style.display = 'none';
}

function menuItemOver(event) {
  var div = (event && event.target ? event.target : window.event.srcElement);
  if (div.nodeName == "A") div = div.parentNode;
  div.style.backgroundColor = "#6394F7";
}

function menuItemOut(event) {
  var div = (event && event.target ? event.target : window.event.srcElement);
  if (div.nodeName == "A") div = div.parentNode;
  div.style.backgroundColor = "";
}

function getMenuItems(nodes) {
  for (var i = 0; i < nodes.length; ++i) {
    if (nodes[i].className == "menuItems") {
      return nodes[i];
    }
  }
}

function regEvt(obj, evt, fnc) {
  if (!obj.addEventListener) {
    obj.attachEvent("on" + evt, fnc);
  }
  else {
    obj.addEventListener(evt, fnc, false);
  }
}
