<?
include "BHSA-Top.php";
?>

<span class="breadcrumbs">
  <a href="/index.php">Home</a> &gt;
  Goodies &gt;
  <b>Email Signup</b>
</span>
<hr>

<div id="emailMessage" style="color: #FFFFFF; background-color: #800000; display: none;">Please enter a valid email address.</div>
<div id="xmlHttpMessage" style="color: #FFFFFF; background-color: #800000; display: none;">The submit process failed. If repeated attempts fail, <a href="mailto:jdechiario@beaumonthsa.org" style="color: #FFFFFF;">please let us know</a>.</div>
<div id="timeoutMessage" style="color: #FFFFFF; background-color: #800000; display: none;">The submit process timed out. If repeated attempts fail, <a href="mailto:jdechiario@beaumonthsa.org" style="color: #FFFFFF;">please let us know</a>.</div>
<div id="errorMessage" style="color: #FFFFFF; background-color: #800000; display: none;"></div>
<div id="step1Message" style="color: #FFFFFF; background-color: #008000; display: none;">You have completed step 1. The step 2 email has been sent.</div>
<br>

Signing up for email notifications is easy.

<ol>
  <li>Enter the information below and click the Submit button.</li>
  <li>Click on the link in the resulting confirmation email.</li>
</ol>

That's it! To change or undo notifications, follow the same process.<br>&nbsp;<br>

<table border="0" cellpadding="4" cellspacing="0" style="font-size: 0.90em;">
  <tr>
    <td style="font-weight: bold;" nowrap>My email address is:&nbsp;&nbsp;</td>
    <td nowrap>
      <input type="text" id="email" name="email" value="" size="25" maxlength="80">
    </td>
  </tr>
  <tr>
    <td style="font-weight: bold;" nowrap>Notify me via email for:&nbsp;&nbsp;</td>
    <td nowrap>
      <input type="checkbox" id="bearFacts" name="bearFacts" checked>Bear Facts&nbsp;&nbsp;
      <input type="checkbox" id="generalInfo" name="generalInfo" checked>General Info&nbsp;&nbsp;
    </td>
  </tr>
</table>&nbsp;<br>

<input type="button" id="submitButton" name="submitButton" value="Submit" onclick="doSubmit()">
<span id="submitStatus" style="color: #008000; font-weight: bold; visibility: hidden;"></span>
<div id="xmlHttpStatus">&nbsp;</div>

<script language="javascript">

var xmlHttp, count, timeoutId;

var emailMessage = document.getElementById("emailMessage");
var xmlHttpMessage = document.getElementById("xmlHttpMessage");
var timeoutMessage = document.getElementById("timeoutMessage");
var errorMessage = document.getElementById("errorMessage");
var step1Message = document.getElementById("step1Message");
var email = document.getElementById("email");
var bearFacts = document.getElementById("bearFacts");
var generalInfo = document.getElementById("generalInfo");
var xmlHttpStatus = document.getElementById("xmlHttpStatus");
var submitButton = document.getElementById("submitButton");
var submitStatus = document.getElementById("submitStatus");

email.focus();

function clearAllMessages() {
  emailMessage.style.display = "none";
  xmlHttpMessage.style.display = "none";
  timeoutMessage.style.display = "none";
  errorMessage.style.display = "none";
  step1Message.style.display = "none";
}

function disableAll() {
  email.disabled = true;
  bearFacts.disabled = true;
  generalInfo.disabled = true;
  submitButton.disabled = true;
}

function enableAll() {
  email.disabled = false;
  bearFacts.disabled = false;
  generalInfo.disabled = false;
  submitButton.disabled = false;
}

function doSubmit() {

  count = 0;
  clearAllMessages();

  var emailValue = email.value;
  var data = "BearFacts:" + (bearFacts.checked ? "Y" : "N") + " GeneralInfo:" + (generalInfo.checked ? "Y" : "N");

  var emailpat = /^([a-zA-Z0-9])+([\.a-zA-Z0-9_-])*@([a-zA-Z0-9])+(\.[a-zA-Z0-9_-]+)+$/;

  if (!emailpat.test(emailValue)) {
    emailMessage.style.display = "block";
    email.focus();
    email.select();
    return;
  }

  xmlHttp = getXMLHttpRequest(); 

  if (!xmlHttp) {
    xmlHttpMessage.style.display = "block";
    return;
  }

  disableAll();
  submitStatus.style.visibility = "visible";
  submitStatus.innerHTML = "Processing submission";
  xmlHttpStatus.innerHTML = "&nbsp;";
  timeoutId = window.setTimeout(updateStatus, 500);

  var sendData = "email=" + escape(emailValue) + "&data=" + escape(data);
/*
  xmlHttp.open("GET", "BHSA-EmailUpdate.php?" + sendData, true);
  xmlHttp.onreadystatechange = doReadyStateChange;
  xmlHttp.send("");
*/
  xmlHttp.open("POST", "BHSA-EmailUpdate.php", true);
  xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
  xmlHttp.setRequestHeader("Content-length", sendData.length);
  xmlHttp.setRequestHeader("Connection", "close");
  xmlHttp.onreadystatechange = doReadyStateChange;
  xmlHttp.send(sendData);

}

function updateStatus() {

  count++;

  if (count > 60) {
    xmlHttp.abort();
    timeoutMessage.style.display = "block";
    submitStatus.style.visibility = "hidden";
    enableAll();
  }
  else if (xmlHttp.readyState != 4) {
    submitStatus.innerHTML += ".";
    timeoutId = window.setTimeout(updateStatus, 500);
  }
  else if (xmlHttp.status != 200) {
    errorMessage.innerHTML = "Submission error during email update: " + xmlHttp.status;
    errorMessage.style.display = "block";
    submitStatus.style.visibility = "hidden";
    enableAll();
  }
  else if (xmlHttp.responseText != "Success") {
    errorMessage.innerHTML = xmlHttp.responseText;
    errorMessage.style.display = "block";
    submitStatus.style.visibility = "hidden";
    enableAll();
  }
  else {
    step1Message.style.display = "block";
    submitStatus.style.visibility = "hidden";
  }
}

function doReadyStateChange() {

//  showStateChange();

  if (xmlHttp.readyState == 4) {
    window.clearTimeout(timeoutId);
    updateStatus();
  }
}

function showStateChange() {

  if (xmlHttp.readyState != 4) {
    xmlHttpStatus.innerHTML = xmlHttp.readyState;
  }
  else if (xmlHttp.status != 200) {
    xmlHttpStatus.innerHTML = xmlHttp.readyState + " " + xmlHttp.status;
  }
  else {
    xmlHttpStatus.innerHTML = xmlHttp.readyState + " " + xmlHttp.status + " " + xmlHttp.responseText;
  }
}

function getXMLHttpRequest() {

  if (window.XMLHttpRequest) {
    return new XMLHttpRequest();
  }

  try { var o = new ActiveXObject("Microsoft.XMLHTTP"); return o; } catch (e) {}
  try { var o = new ActiveXObject("Msxml2.XMLHTTP.3.0"); return o; } catch (e) {}
  try { var o = new ActiveXObject("Msxml2.XMLHTTP"); return o; } catch (e) {}
}

</script>

<hr><p class="update">Last update: 10/28/06</p>

<?
include "BHSA-Bot.php";
?>
