<?
include "../BHSA-Top.php";
?>

<span class="breadcrumbs">
  <a href="/index.php">Home</a> &gt;
  <a href="/secure/admin.php">Admin</a> &gt;
  <b>Login</b>
</span>
<hr>

<div id="entryMessage" style="color: #FFFFFF; background-color: #800000; display: none;">Please enter your id and password.</div>
<div id="failedMessage" style="color: #FFFFFF; background-color: #800000; display: none;">Login failed. Re-enter your id and password.</div>
<div id="changeMessage" style="color: #FFFFFF; background-color: #800000; display: none;">Login failed. You must change your password at this time.</div>
<div id="matchMessage" style="color: #FFFFFF; background-color: #800000; display: none;">You entered new passwords that do not match.</div>
<div id="weakMessage" style="color: #FFFFFF; background-color: #800000; display: none;">You entered a new password that is too weak.</div>
<div id="timeoutMessage" style="color: #FFFFFF; background-color: #800000; display: none;">The login process timed out. If repeated attempts fail, <a href="mailto:jdechiario@beaumonthsa.org" style="color: #FFFFFF;">please let us know</a>.</div>
<div id="errorMessage" style="color: #FFFFFF; background-color: #800000; display: none;"></div>
<br>

Login to the administration pages.<br>&nbsp;<br>

<table border="0" cellpadding="4" cellspacing="0" style="font-size: 0.90em;">
  <tr>
    <td style="font-weight: bold;" nowrap>ID&nbsp;&nbsp;</td>
    <td nowrap>
      <input type="text" id="name" name="name" value="" size="25" maxlength="40">
    </td>
  </tr>
  <tr>
    <td style="font-weight: bold;" nowrap>Password&nbsp;&nbsp;</td>
    <td nowrap>
      <input type="password" id="password" name="password" value="" size="25" maxlength="40">
    </td>
  </tr>
  <tr>
    <td colspan="2" nowrap>&nbsp<br>To change your password, enter it twice below.<br>&nbsp;</td>
    <td nowrap>
      &nbsp;
    </td>
  </tr>
  <tr>
    <td style="font-weight: bold;" nowrap>&nbsp;&nbsp;New Password&nbsp;&nbsp;</td>
    <td nowrap>
      &nbsp;&nbsp;<input type="password" id="password1" name="password1" value="" size="25" maxlength="40">
    </td>
  </tr>
  <tr>
    <td style="font-weight: bold;" nowrap>&nbsp;&nbsp;New Password&nbsp;&nbsp;</td>
    <td nowrap>
      &nbsp;&nbsp;<input type="password" id="password2" name="password2" value="" size="25" maxlength="40">
    </td>
  </tr>
</table>&nbsp;<br>

<input type="button" id="submitButton" name="submitButton" value="Submit" onclick="doSubmit()">
<span id="submitStatus" style="color: #008000; font-weight: bold; visibility: hidden;"></span>
<div id="xmlHttpStatus">&nbsp;</div>

<script language="javascript">

var xmlHttp, count, timeoutId;

var entryMessage = document.getElementById("entryMessage");
var failedMessage = document.getElementById("failedMessage");
var changeMessage = document.getElementById("changeMessage");
var matchMessage = document.getElementById("matchMessage");
var weakMessage = document.getElementById("weakMessage");
var timeoutMessage = document.getElementById("timeoutMessage");
var errorMessage = document.getElementById("errorMessage");

var name = document.getElementById("name");
var password = document.getElementById("password");
var password1 = document.getElementById("password1");
var password2 = document.getElementById("password2");
var xmlHttpStatus = document.getElementById("xmlHttpStatus");
var submitButton = document.getElementById("submitButton");
var submitStatus = document.getElementById("submitStatus");

name.focus();

function clearAllMessages() {
  entryMessage.style.display = "none";
  failedMessage.style.display = "none";
  changeMessage.style.display = "none";
  matchMessage.style.display = "none";
  weakMessage.style.display = "none";
  timeoutMessage.style.display = "none";
  errorMessage.style.display = "none";
}

function disableAll() {
  name.disabled = true;
  password.disabled = true;
  password1.disabled = true;
  password2.disabled = true;
  submitButton.disabled = true;
}

function enableAll() {
  name.disabled = false;
  password.disabled = false;
  password1.disabled = false;
  password2.disabled = false;
  submitButton.disabled = false;
}

function doSubmit() {

  count = 0;
  clearAllMessages();

  var passwordpat = /^(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*\s).*$/;

  if (name.value == "") {
    entryMessage.style.display = "block";
    name.focus();
    return;
  }
  else if (password.value == "") {
    entryMessage.style.display = "block";
    password.focus();
    return;
  }
  else if (password1.value != password2.value) {
    matchMessage.style.display = "block";
    password1.value = "";
    password2.value = "";
    password1.focus();
    return;
  }
  else if (password1.value != "" && !passwordpat.test(password1.value)) {
    weakMessage.style.display = "block";
    password1.value = "";
    password2.value = "";
    password1.focus();
    return;
  }

  xmlHttp = getXMLHttpRequest(); 

  if (!xmlHttp) {
    xmlHttpMessage.style.display = "block";
    return;
  }

  disableAll();
  submitStatus.style.visibility = "visible";
  submitStatus.innerHTML = "Processing login";
  xmlHttpStatus.innerHTML = "&nbsp;";
  timeoutId = window.setTimeout(updateStatus, 500);

  var sendData = "name=" + escape(name.value) + "&password=" + escape(password.value) + "&password1=" + escape(password1.value) + "&password2=" + escape(password2.value);

  xmlHttp.open("POST", "BHSA-Login.php", true);
  xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
  xmlHttp.setRequestHeader("Content-length", sendData.length);
  xmlHttp.setRequestHeader("Connection", "close");
  xmlHttp.onreadystatechange = doReadyStateChange;
  xmlHttp.send(sendData);

}

function updateStatus() {

  count++;

  if (count > 60) {
    xmlHttp.abort();
    timeoutMessage.style.display = "block";
    submitStatus.style.visibility = "hidden";
    enableAll();
  }
  else if (xmlHttp.readyState != 4) {
    submitStatus.innerHTML += ".";
    timeoutId = window.setTimeout(updateStatus, 500);
  }
  else if (xmlHttp.status != 200) {
    errorMessage.innerHTML = "Submission error during login: " + xmlHttp.status;
    errorMessage.style.display = "block";
    submitStatus.style.visibility = "hidden";
    enableAll();
  }
  else if (xmlHttp.responseText == "Change") {
    changeMessage.style.display = "block";
    submitStatus.style.visibility = "hidden";
    enableAll();
    password1.focus();
  }
  else if (xmlHttp.responseText == "Failed") {
    failedMessage.style.display = "block";
    submitStatus.style.visibility = "hidden";
    password.value = "";
    enableAll();
    name.focus();
    name.select();
  }
  else if (xmlHttp.responseText != "Success") {
    errorMessage.innerHTML = xmlHttp.responseText;
    errorMessage.style.display = "block";
    submitStatus.style.visibility = "hidden";
    enableAll();
  }
  else {
    window.location = "http://www.beaumonthsa.org/BHSA-SetName.php";
  }
}

function doReadyStateChange() {

//  showStateChange();

  if (xmlHttp.readyState == 4) {
    window.clearTimeout(timeoutId);
    updateStatus();
  }
}

function showStateChange() {

  if (xmlHttp.readyState != 4) {
    xmlHttpStatus.innerHTML = xmlHttp.readyState;
  }
  else if (xmlHttp.status != 200) {
    xmlHttpStatus.innerHTML = xmlHttp.readyState + " " + xmlHttp.status;
  }
  else {
    xmlHttpStatus.innerHTML = xmlHttp.readyState + " " + xmlHttp.status + " " + xmlHttp.responseText;
  }
}

function getXMLHttpRequest() {

  if (window.XMLHttpRequest) {
    return new XMLHttpRequest();
  }

  try { var o = new ActiveXObject("Microsoft.XMLHTTP"); return o; } catch (e) {}
  try { var o = new ActiveXObject("Msxml2.XMLHTTP.3.0"); return o; } catch (e) {}
  try { var o = new ActiveXObject("Msxml2.XMLHTTP"); return o; } catch (e) {}
}

</script>

<hr><p class="update">Last update: 10/28/06</p>

<?
include "../BHSA-Bot.php";
?>
